import sys
import threading
sys.setrecursionlimit(10**7)

def main():
    input = sys.stdin.readline
    T = int(input())
    
    for _ in range(T):
        N, M = map(int, input().split())
        K = list(map(int, input().split()))
        
        edges = [[] for _ in range(N)]
        for _ in range(M):
            u, v = map(int, input().split())
            edges[u].append(v)
        
        # Tarjan SCC
        index = 0
        indices = [-1]*N
        lowlink = [0]*N
        on_stack = [False]*N
        stack = []
        SCCs = []
        node_to_scc = [-1]*N
        
        def strongconnect(v):
            nonlocal index
            indices[v] = index
            lowlink[v] = index
            index += 1
            stack.append(v)
            on_stack[v] = True
            
            for w in edges[v]:
                if indices[w] == -1:
                    strongconnect(w)
                    lowlink[v] = min(lowlink[v], lowlink[w])
                elif on_stack[w]:
                    lowlink[v] = min(lowlink[v], indices[w])
            
            if lowlink[v] == indices[v]:
                scc = []
                while True:
                    w = stack.pop()
                    on_stack[w] = False
                    scc.append(w)
                    node_to_scc[w] = len(SCCs)
                    if w == v:
                        break
                SCCs.append(scc)
        
        for v in range(N):
            if indices[v] == -1:
                strongconnect(v)
        
        # ????????? ???? SCC ?? sink
        scc_count = len(SCCs)
        scc_outgoing = [0]*scc_count
        for u in range(N):
            for v in edges[u]:
                if node_to_scc[u] != node_to_scc[v]:
                    scc_outgoing[node_to_scc[u]] += 1
        
        max_quality = -1
        for i, scc in enumerate(SCCs):
            if scc_outgoing[i] == 0:
                quality = sum(K[u] for u in scc)
                if quality > 0:
                    max_quality = max(max_quality, quality)
        
        print(max_quality)

threading.Thread(target=main).start()