#include <iostream>
#include <vector>
#include <stack>
#include <climits>
using namespace std;

struct soba {
    int mleko;
    vector<int> adj;
    vector<int> revadj;
};

void dfs1(int u, vector<soba>& s, vector<bool>& visited, stack<int>& st) {
    visited[u] = true;
    for (int v : s[u].adj) {
        if (!visited[v]) dfs1(v, s, visited, st);
    }
    st.push(u);
}

void dfs2(int u, vector<soba>& s, vector<bool>& visited, vector<int>& component) {
    visited[u] = true;
    component.push_back(u);
    for (int v : s[u].revadj) {
        if (!visited[v]) dfs2(v, s, visited, component);
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t; cin >> t;
    while (t--) {
        int n, m;
        cin >> n >> m;

        vector<soba> s(n);
        for (int i = 0; i < n; i++) {
            s[i].adj.clear();
            s[i].revadj.clear();
        }

        for (int i = 0; i < n; i++) {
            cin >> s[i].mleko;
        }

        for (int i = 0; i < m; i++) {
            int u, v;
            cin >> u >> v;
            s[u].adj.push_back(v);
            s[v].revadj.push_back(u);
        }
        vector<bool> visited(n, false);
        stack<int> st;
        for (int i = 0; i < n; i++) {
            if (!visited[i]) dfs1(i, s, visited, st);
        }
        visited.assign(n, false);
        vector<int> compid(n, -1);
        vector<vector<int>> components;
        int cid = 0;

        while (!st.empty()) {
            int u = st.top(); st.pop();
            if (!visited[u]) {
                vector<int> component;
                dfs2(u, s, visited, component);
                for (int node : component) {
                    compid[node] = cid;
                }
                components.push_back(component);
                cid++;
            }
        }
        vector<long long> compsum(cid, 0);
        for (int i = 0; i < n; i++) {
            compsum[compid[i]] += s[i].mleko;
        }
        vector<bool> hasoutedge(cid, false);
        for (int u = 0; u < n; u++) {
            for (int v : s[u].adj) {
                if (compid[u] != compid[v]) {
                    hasoutedge[compid[u]] = true;
                }
            }
        }

        long long k= LLONG_MIN;
        for (int i = 0; i < cid; i++) {
            if (!hasoutedge[i] && compsum[i] > k) {
                k=compsum[i];
            }
        }

        if (k > 0)
            cout << k<< '\n';
        else
            cout << -1 << '\n';
    }

    return 0;
}