#include <iostream>
#include <vector>
#include <string>
#include <stack>
#include <queue>
#include <algorithm>
#include <cmath>
#include <deque>

using namespace std;

#define int long long


void dfs(int i, vector<vector<pair<int, int>>>& g, vector<int>& visited)
{
    visited[i] = 1;
    for (auto j : g[i]) {
        if (!visited[j.first])
            dfs(j.first, g, visited);
    }
}

bool isConnected(int n, vector<vector<pair<int, int>>>& g) {
    vector<int> visited(n, 0);
    dfs(0, g, visited);
    for (int i = 0; i < n; i++)
        if (visited[i] == 0)
            return false;
    return true;
}

void remove_edge(vector<vector<pair<int, int>>>& g, int i, int j)
{
    g[i].erase(remove_if(g[i].begin(), g[i].end(), [j](const pair<int, int>& p) { return p.first == j; }),g[i].end());
    g[j].erase(remove_if(g[j].begin(), g[j].end(), [i](const pair<int, int>& p) { return p.first == i; }),g[j].end());
}

int ans(int n, vector<vector<pair<int, int>>>& g)
{
    int res = 0;
    vector<pair<int, pair<int, int>>> e;
    for (int i = 0; i < n; i++)
    {
        for (auto j : g[i])
        {
            if (i < j.first)
                e.push_back({ j.second, {i, j.first } });
        }
    }
    sort(e.rbegin(), e.rend());
    for (auto i : e)
    {
        remove_edge(g, i.second.first, i.second.second);

        if (!isConnected(n, g))
        {
            g[i.second.first].push_back({ i.second.second, i.first });
            g[i.second.second].push_back({ i.second.first, i.first });
            res += i.first;
        }
    }
    return res;
}

signed main()
{
    int n, m;
    cin >> n >> m;
    vector<int> t(m);
    vector<vector<pair<int, int>>> g(n);
    for (int i = 0; i < m; i++)
    {
        cin >> t[i];
    }
    sort(t.rbegin(), t.rend());
    for (int i = 0; i < n - 1; i++)
    {
        g[i].push_back({ i + 1, t[i] });
        g[i + 1].push_back({ i, t[i] });
    }
    int j = n - 1;
    for (int i = 0; i < n-2 && j < t.size(); i++)
    {
        for (int k = i + 2; k < n && j < t.size(); k++)
        {
            g[i].push_back({ k, t[j] });
            g[k].push_back({ i, t[j] });
            j++;
        }
    }
    cout << ans(n, g);
}