#include <bits/stdc++.h>
using namespace std;

struct Graph {
    int N;
    vector<vector<int>> adj, radj;
    vector<int> visited, order, comp;
    vector<int> Ki;
    Graph(int n): N(n), adj(n), radj(n), visited(n,0), comp(n,-1), Ki(n) {}

    void add_edge(int u, int v){
        adj[u].push_back(v);
        radj[v].push_back(u);
    }

    void dfs1(int u){
        visited[u] = 1;
        for(int v: adj[u])
            if(!visited[v]) dfs1(v);
        order.push_back(u);
    }

    void dfs2(int u, int cid){
        comp[u] = cid;
        for(int v: radj[u])
            if(comp[v] == -1) dfs2(v, cid);
    }

    long long solve(){
        order.clear();
        fill(visited.begin(), visited.end(), 0);
        fill(comp.begin(), comp.end(), -1);

        // 1. Kosaraju: prvi DFS
        for(int i = 0; i < N; i++)
            if(!visited[i]) dfs1(i);

        // 2. Drugi DFS po obrnutom redosledu
        int cid = 0;
        for(int i = N-1; i >= 0; i--){
            int u = order[i];
            if(comp[u] == -1) {
                dfs2(u, cid);
                cid++;
            }
        }

        // 3. Racunamo sumu Ki po komponentama
        vector<long long> comp_sum(cid, 0);
        for(int i = 0; i < N; i++)
            comp_sum[comp[i]] += Ki[i];

        // 4. Pravimo DAG SCC
        vector<int> outdeg(cid, 0);
        for(int u = 0; u < N; u++){
            for(int v: adj[u]){
                if(comp[u] != comp[v]) outdeg[comp[u]]++;
            }
        }

        // 5. Tražimo sink SCC sa maksimalnim pozitivnim zbir
        long long ans = LLONG_MIN;
        for(int i = 0; i < cid; i++){
            if(outdeg[i] == 0 && comp_sum[i] > 0) ans = max(ans, comp_sum[i]);
        }

        if(ans == LLONG_MIN) return -1;
        return ans;
    }
};

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;
    while(T--){
        int N, M;
        cin >> N >> M;
        Graph g(N);
        for(int i = 0; i < N; i++) cin >> g.Ki[i];
        for(int i = 0; i < M; i++){
            int u, v;
            cin >> u >> v;
            g.add_edge(u, v);
        }
        cout << g.solve() << "\n";
    }
    return 0;
}