#include <iostream>
#include <vector>
using namespace std;

vector<vector<int>> g, gr;
vector<bool> visited;
vector<int> comp, order;
vector<long long> K, sumComp;
vector<bool> hasOut;

void dfs1(int u) {
    visited[u] = true;
    for (int v : g[u]) {
        if (!visited[v]) {
            dfs1(v);
        }
    }
    order.push_back(u);
}

void dfs2(int u, int c) {
    comp[u] = c;
    sumComp[c] += K[u];
    for (int v : gr[u]) {
        if (comp[v] == -1) {
            dfs2(v, c);
        }
    }
}

int main() {
    int T;
    cin >> T;

    while (T--) {
        int N, M;
        cin >> N >> M;

        g.assign(N, vector<int>());
        gr.assign(N, vector<int>());
        visited.assign(N, false);
        comp.assign(N, -1);
        K.assign(N, 0);

        for (int i = 0; i < N; i++) {
            cin >> K[i];
        }

        for (int i = 0; i < M; i++) {
            int A, B;
            cin >> A >> B;
            g[A].push_back(B);
            gr[B].push_back(A);
        }

        order.clear();

        // Prvi DFS
        for (int i = 0; i < N; i++) {
            if (!visited[i]) {
                dfs1(i);
            }
        }

        // Drugi DFS
        sumComp.assign(N, 0);
        int cnt = 0;

        for (int i = N - 1; i >= 0; i--) {
            int v = order[i];
            if (comp[v] == -1) {
                dfs2(v, cnt);
                cnt++;
            }
        }

        // Provera izlaza
        hasOut.assign(cnt, false);
        for (int u = 0; u < N; u++) {
            for (int v : g[u]) {
                if (comp[u] != comp[v]) {
                    hasOut[comp[u]] = true;
                }
            }
        }

        // Odgovor
        long long ans = -1;
        for (int i = 0; i < cnt; i++) {
            if (!hasOut[i] && sumComp[i] > 0) {
                if (ans == -1 || sumComp[i] > ans) {
                    ans = sumComp[i];
                }
            }
        }

        cout << ans << endl;
    }

    return 0;
}