#include <bits/stdc++.h>
using namespace std;

struct Edge {
    int u, v, w;
};

struct DSU {
    vector<int> parent, rank;
    DSU(int n) {
        parent.resize(n);
        rank.assign(n, 0);
        for(int i = 0; i < n; i++) parent[i] = i;
    }
    int find(int x) {
        if(parent[x] != x) parent[x] = find(parent[x]);
        return parent[x];
    }
    bool unite(int x, int y) {
        int a = find(x);
        int b = find(y);
        if(a == b) return false;
        if(rank[a] < rank[b]) swap(a,b);
        parent[b] = a;
        if(rank[a] == rank[b]) rank[a]++;
        return true;
    }
};

int main() {
    int N, M;
    cin >> N >> M;

    vector<int> weights(M);
    for(int i = 0; i < M; i++) cin >> weights[i];

    vector<Edge> edges;
    int k = 0;
    for(int i = 0; i < N; i++) {
        for(int j = i+1; j < N && k < M; j++) {
            edges.push_back({i,j, weights[k++]});
        }
    }

    sort(edges.rbegin(), edges.rend(), [](Edge a, Edge b){ return a.w < b.w; });

    DSU dsu(N);
    long long sum = 0;
    int count = 0;

    for(auto e : edges) {
        if(dsu.unite(e.u, e.v)) {
            sum += e.w;
            count++;
            if(count == N-1) break;
        }
    }

    cout << sum << "\n";

    return 0;
}