import collections
import sys

try:
    sys.setrecursionlimit(2000)
except Exception:
    pass 

# --- POMOCNE FUNKCIJE ---

def calculate_cut_size(team1, sve_zelje_set):
    """Izracunava Max-Cut za datu podelu."""
    team1_set = set(team1)
    fulfilled_wishes = 0
    for u, v in sve_zelje_set:
        u_in_t1 = u in team1_set
        v_in_t1 = v in team1_set
        if u_in_t1 != v_in_t1:
            fulfilled_wishes += 1
    return fulfilled_wishes

def citaj_sve_linije_stabilno():
    """ Cita sve linije ulaza. """
    linije = []
    try:
        linije = [line.strip() for line in sys.stdin.readlines()]
    except Exception:
        try:
            while True:
                line = input().strip()
                if not line: break
                linije.append(line)
        except Exception:
            pass 
    return [l for l in linije if l] 


def resi_paintball_problem_final_test():
    
    input_data = citaj_sve_linije_stabilno()
    
    # --- FAZA 0: CITANJE N I M ---
    N, M = 0, 0
    if input_data and input_data[0]:
        try:
            N, M = map(int, input_data[0].split())
        except Exception:
            pass 

    if N <= 1:
        print(f"{N} 0" if N == 1 else "0 0")
        print("1" if N == 1 else "")
        print()
        return

    # --- FAZA 1: CITANJE ŽELJA I GRAÐENJE GRAFA ---
    graf = collections.defaultdict(list)
    sve_zelje_parovi = []
    
    zelja_counter = 0
    for linija_index in range(1, len(input_data)):
        if zelja_counter >= M:
            break
        try:
            linija = input_data[linija_index]
            A, B = map(int, linija.split())
            
            if A != B:
                graf[A].append(B)
                graf[B].append(A)
                sve_zelje_parovi.append(tuple(sorted((A, B))))
            
            zelja_counter += 1
        except Exception:
            zelja_counter += 1
            continue
            
    sve_zelje_set = set(sve_zelje_parovi)

    # --- FAZA 2: ALGORITAM (BFS, MAX-CUT I BALANS PO KOMPONENTAMA) ---
    boja = [0] * (N + 1)
    # Lista svih Max-Cut optimalnih opcija za globalno sastavljanje timova
    optimalne_opcije_komponenti = [] 
    izolovani_clanovi = []
    
    for start_node in range(1, N + 1):
        if boja[start_node] == 0:
            
            if start_node not in graf:
                izolovani_clanovi.append(start_node)
                boja[start_node] = 1 
                continue
                
            queue = collections.deque([start_node])
            boja[start_node] = 1 
            komponenta_boja1 = [start_node]
            komponenta_boja2 = []
            
            # BFS za biparitetnu komponentu
            while queue:
                u = queue.popleft()
                trenutna_boja = boja[u]
                for v in graf[u]:
                    if boja[v] == 0:
                        nova_boja = 3 - trenutna_boja 
                        boja[v] = nova_boja
                        queue.append(v)
                        if nova_boja == 1:
                            komponenta_boja1.append(v)
                        else:
                            komponenta_boja2.append(v)
            
            # Arbitraža Max-Cut / Balans
            ispunjene_opcija1 = calculate_cut_size(komponenta_boja1, sve_zelje_set)
            razlika1 = abs(len(komponenta_boja1) - len(komponenta_boja2))

            ispunjene_opcija2 = calculate_cut_size(komponenta_boja2, sve_zelje_set)
            razlika2 = abs(len(komponenta_boja2) - len(komponenta_boja1))
            
            # Metrika: (Max_Cut, Negativna_Razlika)
            metrika1 = (ispunjene_opcija1, -razlika1)
            metrika2 = (ispunjene_opcija2, -razlika2)
            
            # U ???? 2, ?????? ???? Max-Cut ? ??????? ??????.
            if metrika1 > metrika2:
                optimalne_opcije_komponenti.append((set(komponenta_boja1), set(komponenta_boja2)))
            elif metrika2 > metrika1:
                optimalne_opcije_komponenti.append((set(komponenta_boja2), set(komponenta_boja1)))
            else:
                # Max-Cut i balans su isti. Dodajemo obe opcije za kasniju leksikografsku arbitražu!
                optimalne_opcije_komponenti.append((set(komponenta_boja1), set(komponenta_boja2)))
                optimalne_opcije_komponenti.append((set(komponenta_boja2), set(komponenta_boja1)))


    # --- FAZA 3: KONAC?? ???????? ????????? (Nakon Max-Cut-a) ---
    
    # 3.1: Pronalaženje svih Max-Cut optimalnih podele (Kombinatorika)
    # Ovo je suština problema: moramo probati sve kombinacije Max-Cut opcija
    
    # Ako imamo K komponenti, sa 1 ili 2 opcije, dobijamo 2^K kombinacija.
    # Srecom, Max-Cut je fiksiran, pa proveravamo samo leksikografiju i balans.
    
    # Inicijalizacija sa prvom opcijom (bez izolovanih za sada)
    global_tim1_komb = set()
    global_tim2_komb = set()
    
    if optimalne_opcije_komponenti:
        global_tim1_komb = optimalne_opcije_komponenti[0][0]
        global_tim2_komb = optimalne_opcije_komponenti[0][1]
    
    # Prikupicemo sve leksikografski najbolje kandidate
    najbolji_kandidati = []
    
    # Prebrojavamo ukupan Max-Cut za proveru konzistentnosti (treba da je isti za sve)
    max_cut_referenca = calculate_cut_size(global_tim1_komb, sve_zelje_set)

    # Koristimo itertools.product da napravimo sve kombinacije
    import itertools
    
    if optimalne_opcije_komponenti:
        # Prikupimo sve opcije u listu lista (npr. [[(A1, B1)], [(C1, D1), (D1, C1)]])
        opcije_za_product = []
        i = 0
        while i < len(optimalne_opcije_komponenti):
            opcija1 = optimalne_opcije_komponenti[i]
            if i + 1 < len(optimalne_opcije_komponenti) and optimalne_opcije_komponenti[i+1][0] == opcija1[1]:
                # Ako su opcije simetricne (Max-Cut i balans isti), dodajemo obe
                opcije_za_product.append([opcija1, optimalne_opcije_komponenti[i+1]])
                i += 2
            else:
                # Samo jedna opcija je najbolja
                opcije_za_product.append([opcija1])
                i += 1
                
        # Iteriramo kroz sve kombinacije Max-Cut timova
        for kombinacija in itertools.product(*opcije_za_product):
            T1_temp = set()
            T2_temp = set()
            
            for t1_comp, t2_comp in kombinacija:
                T1_temp.update(t1_comp)
                T2_temp.update(t2_comp)
            
            # Sada balansiramo sa izolovanim cvorovima
            T1_finale = set(T1_temp)
            T2_finale = set(T2_temp)

            for clan in izolovani_clanovi:
                if len(T1_finale) <= len(T2_finale):
                    T1_finale.add(clan)
                else:
                    T2_finale.add(clan)
            
            # Prikupljamo kandidate: (Razlika, Leksikografski T1, T1 lista, T2 lista)
            razlika = abs(len(T1_finale) - len(T2_finale))
            T1_sort = sorted(list(T1_finale))
            
            najbolji_kandidati.append((razlika, T1_sort, list(T1_finale), list(T2_finale)))


    if not najbolji_kandidati:
        # Poseban slucaj: Samo izolovani cvorovi
        T1_finale = set()
        T2_finale = set()
        for clan in izolovani_clanovi:
             if len(T1_finale) <= len(T2_finale):
                T1_finale.add(clan)
             else:
                T2_finale.add(clan)
        
        najbolji_kandidati.append((abs(len(T1_finale) - len(T2_finale)), sorted(list(T1_finale)), list(T1_finale), list(T2_finale)))


    # KONACNA ARBITRAŽA: Bira se leksikografski najmanji kandidat
    # Sortiramo po: 1. Razlika, 2. Leksikografski T1
    najbolji_kandidati.sort(key=lambda x: (x[0], x[1]))
    
    # Uzimamo prvu (najbolju) podelu po metrikama
    najbolji_tim1 = najbolji_kandidati[0][2]
    najbolji_tim2 = najbolji_kandidati[0][3]


    # --- FAZA 4: KONACAN ISPIS ---
    
    P = len(najbolji_tim1)
    D = len(najbolji_tim2)
    
    najbolji_tim1.sort()
    najbolji_tim2.sort()

    print(f"{P} {D}")
    
    if najbolji_tim1:
        print(*(najbolji_tim1))
    else:
        print() 
        
    if najbolji_tim2:
        print(*(najbolji_tim2))
    else:
        print() 
        
if __name__ == "__main__":
    resi_paintball_problem_final_test()