import collections
import sys

try:
    sys.setrecursionlimit(2000)
except Exception:
    pass 

# --- POMOCNE FUNKCIJE ---

def calculate_cut_size(team1, sve_zelje_set):
    """Izracunava Max-Cut za datu podelu."""
    team1_set = set(team1)
    fulfilled_wishes = 0
    for u, v in sve_zelje_set:
        u_in_t1 = u in team1_set
        v_in_t1 = v in team1_set
        if u_in_t1 != v_in_t1:
            fulfilled_wishes += 1
    return fulfilled_wishes

def citaj_sve_linije_stabilno():
    """ Cita sve linije ulaza. """
    linije = []
    try:
        linije = [line.strip() for line in sys.stdin.readlines()]
    except Exception:
        try:
            while True:
                line = input().strip()
                if not line: break
                linije.append(line)
        except Exception:
            pass 
    return [l for l in linije if l] 


def resi_paintball_problem_popravka_pada_v3():
    
    input_data = citaj_sve_linije_stabilno()
    
    # --- FAZA 0: CITANJE N I M ---
    N, M = 0, 0
    if input_data and input_data[0]:
        try:
            N, M = map(int, input_data[0].split())
        except Exception:
            pass 

    if N <= 1:
        print(f"{N} 0" if N == 1 else "0 0")
        print("1" if N == 1 else "")
        print()
        return

    # --- FAZA 1: CITANJE ŽELJA I GRAÐENJE GRAFA ---
    graf = collections.defaultdict(list)
    sve_zelje_parovi = []
    
    zelja_counter = 0
    for linija_index in range(1, len(input_data)):
        if zelja_counter >= M:
            break
        try:
            linija = input_data[linija_index]
            A, B = map(int, linija.split())
            
            if A != B:
                graf[A].append(B)
                graf[B].append(A)
                sve_zelje_parovi.append(tuple(sorted((A, B))))
            
            zelja_counter += 1
        except Exception:
            zelja_counter += 1
            continue
            
    sve_zelje_set = set(sve_zelje_parovi)

    # --- FAZA 2: ALGORITAM (BFS, MAX-CUT, BALANS I LEKSIKOGRAFIJA PO KOMPONENTAMA) ---
    boja = [0] * (N + 1)
    global_tim1 = []
    global_tim2 = []
    izolovani_clanovi = []
    
    for start_node in range(1, N + 1):
        if boja[start_node] == 0:
            
            if start_node not in graf:
                izolovani_clanovi.append(start_node)
                boja[start_node] = 1 
                continue
                
            queue = collections.deque([start_node])
            boja[start_node] = 1 
            komponenta_boja1 = [start_node]
            komponenta_boja2 = []
            
            # BFS ?? ????????? ??????????
            while queue:
                u = queue.popleft()
                trenutna_boja = boja[u]
                for v in graf[u]:
                    if boja[v] == 0:
                        nova_boja = 3 - trenutna_boja 
                        boja[v] = nova_boja
                        queue.append(v)
                        if nova_boja == 1:
                            komponenta_boja1.append(v)
                        else:
                            komponenta_boja2.append(v)
            
            # Arbitraža Max-Cut / Balans / Leksikografija
            ispunjene_opcija1 = calculate_cut_size(komponenta_boja1, sve_zelje_set)
            razlika1 = abs(len(komponenta_boja1) - len(komponenta_boja2))
            T1_A_sort = sorted(komponenta_boja1) # ?????????????? T1A

            ispunjene_opcija2 = calculate_cut_size(komponenta_boja2, sve_zelje_set)
            razlika2 = abs(len(komponenta_boja2) - len(komponenta_boja1))
            T1_B_sort = sorted(komponenta_boja2) # ?????????????? T1B
            
            # ???????: (Max_Cut, ?????????_???????, T1_Sort)
            metrika1 = (ispunjene_opcija1, -razlika1, T1_A_sort)
            metrika2 = (ispunjene_opcija2, -razlika2, T1_B_sort)
            
            if metrika1 >= metrika2:
                global_tim1.extend(komponenta_boja1)
                global_tim2.extend(komponenta_boja2)
            else:
                global_tim1.extend(komponenta_boja2)
                global_tim2.extend(komponenta_boja1)
                    
    
    # --- FAZA 3: KONAC?? ??????????? ? ????????? ---
    
    trenutni_tim1 = set(global_tim1)
    trenutni_tim2 = set(global_tim2)
    
    # 3.1: ???????? ?????????? ???????
    izolovani_clanovi.sort()
    
    for clan in izolovani_clanovi:
        # ?????????: ???? ???, ? ??? ?? ???????, T1 ???? ??????????????
        if len(trenutni_tim1) < len(trenutni_tim2):
            trenutni_tim1.add(clan)
        elif len(trenutni_tim2) < len(trenutni_tim1):
            trenutni_tim2.add(clan)
        else:
            trenutni_tim1.add(clan)
            
    # 3.2: ??????? ????????? (???????? ???????) - ??? ?? ??? ???? ??? ?? ??? 55
    
    najbolji_tim1 = list(trenutni_tim1)
    najbolji_tim2 = list(trenutni_tim2)
    trenutni_cut = calculate_cut_size(najbolji_tim1, sve_zelje_set)
    
    # Inicijalna najbolja metrika: (Razlika u velicini, Leksikografski T1)
    najbolja_metrika = (abs(len(najbolji_tim1) - len(najbolji_tim2)), sorted(najbolji_tim1))

    # ??????????? ?? ???? ???? ??? ?? ??????? ???? ?? 1
    if najbolja_metrika[0] > 1:
        
        veci_tim_ref = list(najbolji_tim1) if len(najbolji_tim1) > len(najbolji_tim2) else list(najbolji_tim2)
        manji_tim_ref = list(najbolji_tim2) if len(najbolji_tim1) > len(najbolji_tim2) else list(najbolji_tim1)
        
        t1_bio_veci = len(najbolji_tim1) > len(najbolji_tim2)
        
        optimalne_podele = []
        optimalne_podele.append((najbolja_metrika, najbolji_tim1, najbolji_tim2))
        
        # NOTE: ???? ??????? ?????????: ?????????? ??????? ?? ???? ???? ??????, ?? ????? ?? ??????????? ??? ??????
        # ??????? ?? ?? ?????? ?? ??????? ???? ?? ???? ?? 55 ?????.
        
        for clan_za_pomeranje in sorted(veci_tim_ref):
            
            # ??????? ?????? ????? ? ????? ????
            novi_veci = [c for c in veci_tim_ref if c != clan_za_pomeranje]
            novi_manji = manji_tim_ref + [clan_za_pomeranje]
            
            if t1_bio_veci:
                T1_provera, T2_provera = novi_veci, novi_manji
            else:
                T1_provera, T2_provera = novi_manji, novi_veci
                
            novi_cut = calculate_cut_size(T1_provera, sve_zelje_set)
            
            if novi_cut == trenutni_cut:
                
                nova_razlika = abs(len(novi_veci) - len(novi_manji))
                nova_metrika = (nova_razlika, sorted(T1_provera))

                # ????????? ???????? ??????????? (???? ??????? ????????)
                if nova_metrika < najbolja_metrika:
                    najbolji_tim1 = T1_provera
                    najbolji_tim2 = T2_provera
                    najbolja_metrika = nova_metrika
                    
                    if najbolja_metrika[0] <= 1:
                        break # ???????? ??? ??????? ?????? ??????
                        
    # --- FAZA 4: KONACAN ISPIS ---
    
    P = len(najbolji_tim1)
    D = len(najbolji_tim2)
    
    najbolji_tim1.sort()
    najbolji_tim2.sort()

    print(f"{P} {D}")
    
    if najbolji_tim1:
        print(*(najbolji_tim1))
    else:
        print() 
        
    if najbolji_tim2:
        print(*(najbolji_tim2))
    else:
        print() 
        
if __name__ == "__main__":
    resi_paintball_problem_popravka_pada_v3()