import collections
import sys

try:
    sys.setrecursionlimit(2000)
except Exception:
    pass 

# --- POMOCNE FUNKCIJE ---

def calculate_cut_size(team1, sve_zelje_set):
    """Izracunava Max-Cut za datu podelu."""
    team1_set = set(team1)
    fulfilled_wishes = 0
    for u, v in sve_zelje_set:
        u_in_t1 = u in team1_set
        v_in_t1 = v in team1_set
        if u_in_t1 != v_in_t1:
            fulfilled_wishes += 1
    return fulfilled_wishes

def citaj_sve_linije_stabilno():
    """ Cita sve linije ulaza. """
    linije = []
    try:
        linije = [line.strip() for line in sys.stdin.readlines()]
    except Exception:
        try:
            while True:
                line = input().strip()
                if not line: break
                linije.append(line)
        except Exception:
            pass 
    return [l for l in linije if l] 


def resi_paintball_problem_100_final_v5_bez_iteracije():
    
    input_data = citaj_sve_linije_stabilno()
    
    # --- FAZA 0: CITANJE N I M ---
    N, M = 0, 0
    if input_data and input_data[0]:
        try:
            N, M = map(int, input_data[0].split())
        except Exception:
            pass 

    if N <= 1:
        print(f"{N} 0" if N == 1 else "0 0")
        print("1" if N == 1 else "")
        print()
        return

    # --- FAZA 1: CITANJE ŽELJA I GRAÐENJE GRAFA ---
    graf = collections.defaultdict(list)
    sve_zelje_parovi = []
    
    zelja_counter = 0
    for linija_index in range(1, len(input_data)):
        if zelja_counter >= M:
            break
        try:
            linija = input_data[linija_index]
            A, B = map(int, linija.split())
            
            if A != B:
                graf[A].append(B)
                graf[B].append(A)
                sve_zelje_parovi.append(tuple(sorted((A, B))))
            
            zelja_counter += 1
        except Exception:
            zelja_counter += 1
            continue
            
    sve_zelje_set = set(sve_zelje_parovi)

    # --- FAZA 2: ALGORITAM (Max-Cut, BALANS I LEKSIKOGRAFIJA PO KOMPONENTAMA) ---
    boja = [0] * (N + 1)
    global_tim1 = []
    global_tim2 = []
    izolovani_clanovi = []
    
    for start_node in range(1, N + 1):
        if boja[start_node] == 0:
            
            if start_node not in graf:
                izolovani_clanovi.append(start_node)
                boja[start_node] = 1 
                continue
                
            queue = collections.deque([start_node])
            boja[start_node] = 1 
            komponenta_boja1 = [start_node]
            komponenta_boja2 = []
            
            # BFS
            while queue:
                u = queue.popleft()
                trenutna_boja = boja[u]
                for v in graf[u]:
                    if boja[v] == 0:
                        nova_boja = 3 - trenutna_boja 
                        boja[v] = nova_boja
                        queue.append(v)
                        if nova_boja == 1:
                            komponenta_boja1.append(v)
                        else:
                            komponenta_boja2.append(v)
            
            # Arbitraža Max-Cut / Balans / Leksikografija
            ispunjene_opcija1 = calculate_cut_size(komponenta_boja1, sve_zelje_set)
            razlika1 = abs(len(komponenta_boja1) - len(komponenta_boja2))
            T1_A_sort = sorted(komponenta_boja1) 

            ispunjene_opcija2 = calculate_cut_size(komponenta_boja2, sve_zelje_set)
            razlika2 = abs(len(komponenta_boja2) - len(komponenta_boja1))
            T1_B_sort = sorted(komponenta_boja2) 
            
            # ???????: (Max_Cut, ?????????_???????, T1_Sort)
            metrika1 = (ispunjene_opcija1, -razlika1, T1_A_sort)
            metrika2 = (ispunjene_opcija2, -razlika2, T1_B_sort)
            
            if metrika1 >= metrika2:
                global_tim1.extend(komponenta_boja1)
                global_tim2.extend(komponenta_boja2)
            else:
                global_tim1.extend(komponenta_boja2)
                global_tim2.extend(komponenta_boja1)
                    
    
    # --- FAZA 3: KONAC?? ??????????? (???? ????????? ???????) ---
    
    trenutni_tim1 = set(global_tim1)
    trenutni_tim2 = set(global_tim2)
    
    # 3.1: ???????? ?????????? ???????
    izolovani_clanovi.sort()
    
    for clan in izolovani_clanovi:
        # ?????????: ???? ???, ? ??? ?? ???????, T1 ???? ??????????????
        if len(trenutni_tim1) < len(trenutni_tim2):
            trenutni_tim1.add(clan)
        elif len(trenutni_tim2) < len(trenutni_tim1):
            trenutni_tim2.add(clan)
        else:
            trenutni_tim1.add(clan)
            
    # 3.2: UKLONJENO: ???? ?????????? Max-Cut ???????.
    
    najbolji_tim1 = list(trenutni_tim1)
    najbolji_tim2 = list(trenutni_tim2)

    # --- FAZA 4: KONACAN ISPIS ---
    
    P = len(najbolji_tim1)
    D = len(najbolji_tim2)
    
    najbolji_tim1.sort()
    najbolji_tim2.sort()

    print(f"{P} {D}")
    
    if najbolji_tim1:
        print(*(najbolji_tim1))
    else:
        print() 
        
    if najbolji_tim2:
        print(*(najbolji_tim2))
    else:
        print() 
        
if __name__ == "__main__":
    resi_paintball_problem_100_final_v5_bez_iteracije()