using System;
using System.Collections.Generic;

class SobeIHodnici
{
    static int[] tezina;
    static int maksimalniKvalitet;
    static int trenutniZbir;

    static void Main()
    {
        int t = int.Parse(Console.ReadLine());

        List<int> ns = new List<int>();
        List<int[]> tezine = new List<int[]>();
        List<List<List<int>>> svi = new List<List<List<int>>>();

        for (int test = 0; test < t; test++)
        {
            int n = int.Parse(Console.ReadLine());
            int m = int.Parse(Console.ReadLine());

            int[] tez = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);

            int[,] matrica = new int[n, n];

            for (int i = 0; i < m; i++)
            {
                var linija = Console.ReadLine().Split();
                int u = int.Parse(linija[0]);
                int v = int.Parse(linija[1]);
                matrica[u, v] = 1;
            }

            List<List<int>> susedi = new List<List<int>>();
            for (int i = 0; i < n; i++)
            {
                susedi.Add(new List<int>());
                for (int j = 0; j < n; j++)
                    if (matrica[i, j] == 1)
                        susedi[i].Add(j);
            }

            ns.Add(n);
            tezine.Add(tez);
            svi.Add(susedi);
        }
        for (int test = 0; test < t; test++)
        {
            tezina = tezine[test];
            maksimalniKvalitet = int.MinValue;
            trenutniZbir = 0;

            for (int i = 0; i < ns[test]; i++)
                DFS(i, svi[test]);

            Console.WriteLine(maksimalniKvalitet > 0 ? maksimalniKvalitet : -1);
        }
    }

    static void DFS(int cvor, List<List<int>> susedi, bool[] posecen)
    {
        posecen[cvor] = true;
        trenutniZbir += tezina[cvor];

        if (susedi[cvor].Count == 0)
        {
            maksimalniKvalitet = Math.Max(maksimalniKvalitet, trenutniZbir);
        }
        else
        {
            foreach (int sused in susedi[cvor])
                if (!posecen[sused])
                    DFS(sused, susedi, posecen);
        }

        trenutniZbir -= tezina[cvor];
        posecen[cvor] = false;
    }

    static void DFS(int cvor, List<List<int>> susedi)
    {
        bool[] posecen = new bool[susedi.Count];
        DFS(cvor, susedi, posecen);
    }
}