#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#define VRLO_VELIKO 1e38 

int *adj_glava;
int *adj_ka;
int *adj_sle;
int br_grana;

int *posecen;
int *scc_id;
long long *scc_k;
int scc_br;

int *stek_niz;
int stek_vrh;

long long *dp_vrednost;
long long *Mleko;

void napravi_graf(int N, int M) {
    int max_grane = M;
    
    if (adj_glava) free(adj_glava);
    if (adj_ka) free(adj_ka);
    if (adj_sle) free(adj_sle);

    adj_glava = (int*)calloc(N, sizeof(int));
    adj_ka = (int*)malloc(max_grane * sizeof(int));
    adj_sle = (int*)malloc(max_grane * sizeof(int));
    br_grana = 0;
}

void dodaj_liniju(int u, int v) {
    adj_ka[br_grana] = v;
    adj_sle[br_grana] = adj_glava[u];
    adj_glava[u] = br_grana + 1;
    br_grana++;
}

void udji_u_sobu1(int u) {
    posecen[u] = 1;
    
    for (int i = adj_glava[u]; i != 0; i = adj_sle[i - 1]) {
        int v = adj_ka[i - 1];
        if (!posecen[v]) {
            udji_u_sobu1(v);
        }
    }
    stek_niz[++stek_vrh] = u;
}

void udji_u_sobu2(int u, int scc_id_tren) {
    scc_id[u] = scc_id_tren;
    scc_k[scc_id_tren] += Mleko[u];

    for (int i = adj_glava[u]; i != 0; i = adj_sle[i - 1]) {
        int v = adj_ka[i - 1];
        if (scc_id[v] == -1) {
            udji_u_sobu2(v, scc_id_tren);
        }
    }
}

long long vecje(long long a, long long b) {
    return (a > b) ? a : b;
}

int *scc_adj_glava;
int *scc_adj_ka;
int *scc_adj_sle;
int scc_br_grana;

void napravi_scc_graf(int N) {
    int max_scc_grane = N * (N - 1) / 2;
    
    if (scc_adj_glava) free(scc_adj_glava);
    if (scc_adj_ka) free(scc_adj_ka);
    if (scc_adj_sle) free(scc_adj_sle);

    scc_adj_glava = (int*)calloc(N, sizeof(int));
    scc_adj_ka = (int*)malloc(max_scc_grane * sizeof(int));
    scc_adj_sle = (int*)malloc(max_scc_grane * sizeof(int));
    scc_br_grana = 0;
}

void dodaj_scc_liniju(int u, int v) {
    scc_adj_ka[scc_br_grana] = v;
    scc_adj_sle[scc_br_grana] = scc_adj_glava[u];
    scc_adj_glava[u] = scc_br_grana + 1;
    scc_br_grana++;
}

long long nadji_max_mleko(int u) {
    if (dp_vrednost[u] != -1) {
        return dp_vrednost[u];
    }

    long long trenutni_kv = scc_k[u];
    long long max_dete_kv = 0;

    for (int i = scc_adj_glava[u]; i != 0; i = scc_adj_sle[i - 1]) {
        int v = scc_adj_ka[i - 1];
        
        long long dete_dp = nadji_max_mleko(v);
        
        max_dete_kv += vecje(0, dete_dp);
    }

    dp_vrednost[u] = trenutni_kv + max_dete_kv;
    return dp_vrednost[u];
}

void resi_slucaj() {
    int N, M;
    if (scanf("%d %d", &N, &M) != 2) return;

    Mleko = (long long*)malloc(N * sizeof(long long));
    posecen = (int*)calloc(N, sizeof(int));
    scc_id = (int*)malloc(N * sizeof(int));
    stek_niz = (int*)malloc(N * sizeof(int));
    stek_vrh = -1;
    scc_br = 0;

    for (int i = 0; i < N; ++i) {
        if (scanf("%lld", &Mleko[i]) != 1) return;
        scc_id[i] = -1;
    }
    
    napravi_graf(N, M);
    napravi_scc_graf(N);

    int *rev_glava = (int*)calloc(N, sizeof(int));
    int *orig_glava = (int*)calloc(N, sizeof(int));
    
    for (int i = 0; i < M; ++i) {
        int u, v;
        if (scanf("%d %d", &u, &v) != 2) return;
        
        adj_ka[br_grana] = v;
        adj_sle[br_grana] = orig_glava[u];
        orig_glava[u] = br_grana + 1;
        
        adj_ka[br_grana + M] = u;
        adj_sle[br_grana + M] = rev_glava[v];
        rev_glava[v] = br_grana + M + 1;
        
        br_grana++;
    }
  
    adj_glava = orig_glava;
    for (int i = 0; i < N; ++i) {
        if (!posecen[i]) {
            udji_u_sobu1(i);
        }
    }

    scc_k = (long long*)calloc(N, sizeof(long long));
    adj_glava = rev_glava;
 
    while (stek_vrh != -1) {
        int u = stek_niz[stek_vrh--];
        if (scc_id[u] == -1) {
            udji_u_sobu2(u, scc_br);
            scc_br++;
        }
    }
 
    char *postoji_linija = (char*)calloc(scc_br * scc_br, sizeof(char));
    adj_glava = orig_glava;

    for (int u = 0; u < N; ++u) {
        for (int i = adj_glava[u]; i != 0; i = adj_sle[i - 1]) {
            int v = adj_ka[i - 1];
            
            int scc_u = scc_id[u];
            int scc_v = scc_id[v];
            
            if (scc_u != scc_v) {
                if (postoji_linija[scc_u * scc_br + scc_v] == 0) {
                    dodaj_scc_liniju(scc_u, scc_v);
                    postoji_linija[scc_u * scc_br + scc_v] = 1;
                }
            }
        }
    }
    free(postoji_linija);
 
    dp_vrednost = (long long*)malloc(scc_br * sizeof(long long));
    for(int i=0; i<scc_br; ++i) dp_vrednost[i] = -1;

    long long max_kvalitet = -1;

    for (int i = 0; i < scc_br; ++i) {
        long long trenutni_dp = nadji_max_mleko(i);
        
        if (trenutni_dp > 0) {
            max_kvalitet = vecje(max_kvalitet, trenutni_dp);
        }
    }

    free(Mleko); free(posecen); free(scc_id); free(stek_niz); free(scc_k); free(dp_vrednost);
    free(orig_glava); free(rev_glava);
    
    printf("%lld\n", max_kvalitet);
}

int main() {
    int T;
    if (scanf("%d", &T) != 1) return 0;
    
    adj_glava = NULL;
    adj_ka = NULL;
    adj_sle = NULL;
    scc_adj_glava = NULL;
    scc_adj_ka = NULL;
    scc_adj_sle = NULL;
    
    while (T--) {
        resi_slucaj();
    }

    if (adj_ka) free(adj_ka);
    if (adj_sle) free(adj_sle);
    if (scc_adj_glava) free(scc_adj_glava);
    if (scc_adj_ka) free(scc_adj_ka);
    if (scc_adj_sle) free(scc_adj_sle);

    return 0;
}