#include <iostream>
#include <vector>
using namespace std;

int main() {
    int n, m;
    cin >> n >> m;
    
    vector<pair<int, int>> edges(m);
    vector<vector<int>> adj(n + 1);
    
    for (int i = 0; i < m; i++) {
        int a, b;
        cin >> a >> b;
        edges[i] = {a, b};
        adj[a].push_back(b);
        adj[b].push_back(a);
    }
    
    vector<int> team(n + 1, 0);
    
    bool improved = true;
    while (improved) {
        improved = false;
        for (int u = 1; u <= n; u++) {
            int same_team = 0, diff_team = 0;
            for (int v : adj[u]) {
                if (team[u] == team[v]) same_team++;
                else diff_team++;
            }
            
            if (same_team > diff_team) {
                team[u] = 1 - team[u];
                improved = true;
            }
        }
    }
    
    vector<int> t0, t1;
    for (int i = 1; i <= n; i++) {
        if (team[i] == 0) t0.push_back(i);
        else t1.push_back(i);
    }
    
    cout << t0.size() << " " << t1.size() << "\n";
    for (int x : t0) cout << x << " ";
    cout << "\n";
    for (int x : t1) cout << x << " ";
    cout << "\n";
    
    return 0;
}