#include <iostream>
#include <vector>
#include <stack>
#include <climits>

int t, n, m, arr[10000];
std::vector<std::vector<int>> g;
int otkriven[10000], minimumi[10000], scc_id[10000], da_li_je_na_stacku[10000];
int scc_zbir[10000];
int scc_izlazi[10000];
int br, n_scc;
std::stack<int> st;

void tarjan(int u) {
    otkriven[u]=minimumi[u]=br++;
    st.push(u);
    da_li_je_na_stacku[u]=1;

    for (int v:g[u]) {
        if (!otkriven[v]) {
            tarjan(v);
            minimumi[u] = std::min(minimumi[u], minimumi[v]);
        } else if (da_li_je_na_stacku[v]) minimumi[u]=std::min(minimumi[u], otkriven[v]);
    }

    if (minimumi[u]==otkriven[u]) {
        n_scc++;
        int sum=0;
        while (true) {
            int v=st.top();
            st.pop();
            da_li_je_na_stacku[v]=0;
            scc_id[v]=n_scc;
            sum+=arr[v];
            if (v==u) break;
        }
        scc_zbir[n_scc]=sum;
    }
}

int main()
{
    scanf("%d", &t);
    for (int i=0; i<t; i++) {
        scanf("%d", &n);
        scanf("%d", &m);
        
        for (int i=0; i<n; i++) scanf("%d", &arr[i]);

        g.assign(n, std::vector<int>());
        std::vector<std::pair<int,int>> edges;
        for (int i=0; i<m; i++) {
            int u, v;
            scanf("%d", &u);
            scanf("%d", &v);
            g[u].push_back(v);
            edges.emplace_back(u,v);
        }
        
        for (int i=0; i<n; i++) {
            otkriven[i]=0;
            minimumi[i]=0;
            scc_id[i]=0;
            da_li_je_na_stacku[i]=0;
        }
        
        while (!st.empty()) st.pop();
        
        for (int i=0; i<=n; i++) {
            scc_zbir[i]=0;
            scc_izlazi[i]=0;
        }
        
        br=0;
        n_scc=0;

        for (int i=0; i<n; i++) {
            if (!otkriven[i]) tarjan(i);
        }

        for (auto &e:edges) {
            int u=e.first, v=e.second;
            if (scc_id[u]!=scc_id[v]) scc_izlazi[scc_id[u]]++;
        }

        int maximum=INT_MIN;
        for (int c=1; c<=n_scc; c++) {
            if (scc_izlazi[c]==0) {
                if (scc_zbir[c]>maximum) maximum=scc_zbir[c];
            }
        }

        if (maximum>0) printf("%lld\n", maximum+1);
        else printf("-1\n");
    }

    return 0;
}