#include <bits/stdc++.h>
using namespace std;

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    long long m;
    cin >> n >> m;

    vector<pair<int,int>> e;
    e.reserve(m);
    vector<vector<int>> g(n+1);

    for(long long i=0;i<m;i++){
        int a,b; 
        cin >> a >> b;
        e.push_back({a,b});
        g[a].push_back(b);
        g[b].push_back(a);
    }

    vector<int> s(n+1,0);     
    vector<int> deg(n+1), ok(n+1,0);

    for(int i=1;i<=n;i++) deg[i] = g[i].size();

    deque<int> q;
    vector<char> inq(n+1,0);

    for(int i=1;i<=n;i++){
        if(deg[i] - 2*ok[i] > 0){
            q.push_back(i);
            inq[i] = 1;
        }
    }

    while(!q.empty()){
        int v = q.front(); 
        q.pop_front();
        inq[v] = 0;

        if(deg[v] - 2*ok[v] <= 0) continue;

        int pre = s[v];
        int posle = 1 - pre;
        s[v] = posle;

        ok[v] = deg[v] - ok[v];

        for(int u : g[v]){
            if(s[u] == pre) ok[u]++; 
            else ok[u]--;

            if(!inq[u] && deg[u] - 2*ok[u] > 0){
                q.push_back(u);
                inq[u] = 1;
            }
        }
    }

    long long cnt = 0;
    for(auto &p : e){
        if(s[p.first] != s[p.second]) cnt++;
    }

    if(cnt < m/2){
        cout << -1 << "\n";
        return 0;
    }

    vector<int> t0, t1;
    for(int i=1;i<=n;i++){
        if(s[i]==0) t0.push_back(i);
        else t1.push_back(i);
    }

    if(t0.empty()){
        s[1] = 0;
        t0.push_back(1);
        t1.erase(find(t1.begin(), t1.end(), 1));
    }
    else if(t1.empty()){
        s[1] = 1;
        t1.push_back(1);
        t0.erase(find(t0.begin(), t0.end(), 1));
    }

    t0.clear();
    t1.clear();
    for(int i=1;i<=n;i++){
        if(s[i]==0) t0.push_back(i);
        else t1.push_back(i);
    }

    cout << t0.size() << " " << t1.size() << "\n";
    for(int i=0;i<t0.size();i++){
        if(i) cout<<" ";
        cout << t0[i];
    }
    cout << "\n";
    for(int i=0;i<t1.size();i++){
        if(i) cout<<" ";
        cout << t1[i];
    }
    cout << "\n";

    return 0;
}