#include <bits/stdc++.h>
using namespace std;
using ll = long long;

struct Edge {
    int to;
    ll cap;
    int rev;
    Edge(int _to, ll _cap, int _rev) : to(_to), cap(_cap), rev(_rev) {}
};

struct Dinic {
    int n;
    vector<vector<Edge>> g;
    vector<int> level, it;
    Dinic(int n=0): n(n), g(n), level(n), it(n) {}
    void add_edge(int u, int v, ll c){
        g[u].emplace_back(v,c,(int)g[v].size());
        g[v].emplace_back(u,0,(int)g[u].size()-1);
    }
    bool bfs(int s, int t){
        fill(level.begin(), level.end(), -1);
        queue<int> q;
        level[s]=0;
        q.push(s);
        while(!q.empty()){
            int v=q.front(); q.pop();
            for(const Edge &e: g[v]){
                if(level[e.to] < 0 && e.cap>0){
                    level[e.to] = level[v]+1;
                    q.push(e.to);
                }
            }
        }
        return level[t] >= 0;
    }
    ll dfs(int v, int t, ll f){
        if(v==t) return f;
        for(int &i = it[v]; i < (int)g[v].size(); ++i){
            Edge &e = g[v][i];
            if(e.cap>0 && level[e.to] == level[v]+1){
                ll ret = dfs(e.to, t, min(f, e.cap));
                if(ret>0){
                    e.cap -= ret;
                    g[e.to][e.rev].cap += ret;
                    return ret;
                }
            }
        }
        return 0;
    }
    ll maxflow(int s, int t){
        ll flow = 0;
        const ll INF_FLOW = (ll)9e18;
        while(bfs(s,t)){
            fill(it.begin(), it.end(), 0);
            while(true){
                ll pushed = dfs(s,t,INF_FLOW);
                if(pushed==0) break;
                flow += pushed;
            }
        }
        return flow;
    }
};

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
#if !defined(ONLINE_JUDGE)
#endif
    int T;
    if(!(cin >> T)) return 0;
    while(T--){
        int N, M;
        cin >> N >> M;
        vector<ll> K(N);
        for(int i=0;i<N;++i) cin >> K[i];
        vector<pair<int,int>> edges;
        edges.reserve(M);
        for(int i=0;i<M;++i){
            int A,B;
            cin >> A >> B;
            edges.emplace_back(A,B);
        }

        int S = N; 
        int Tt = N+1; 
        Dinic D(N+2);
        ll sumPos = 0;
        const ll INF = (ll)4e18; 
        for(int i=0;i<N;++i){
            if(K[i] > 0){
                D.add_edge(S, i, K[i]);
                sumPos += K[i];
            } else if(K[i] < 0){
                D.add_edge(i, Tt, -K[i]);
            }
        }
        for(auto &e : edges){
            int u = e.first;
            int v = e.second;
            D.add_edge(u, v, INF);
        }

        ll flow = D.maxflow(S, Tt);
        ll best = sumPos - flow;
        if(best <= 0) cout << -1 << '\n';
        else cout << best << '\n';
    }
    return 0;
}