using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
public class Program
{
    private static List<int>[] adj;
    private static int[] boja; 

    public class Komponenta
    {
        public List<int> S1 { get; set; } 
        public List<int> S2 { get; set; } 
        public long Ispunjenost1 { get; set; } 
        public long Ispunjenost2 { get; set; } 

        public Komponenta()
        {
            S1 = new List<int>();
            S2 = new List<int>();
        }
    }

    private static (long ispunjeno1, long ispunjeno2) BFS_Coloring(int startNode, int N, List<int>[] adj, out List<int> componentNodes)
    {
        Queue<int> queue = new Queue<int>();
        queue.Enqueue(startNode);
        boja[startNode] = 1; 

        long totalEdges = 0;  
        long neispunjeno1 = 0; 
        long neispunjeno2 = 0; 
        
        List<int> currentComponentNodes = new List<int>();
        
        Queue<int> q_bfs = new Queue<int>();
        q_bfs.Enqueue(startNode);
        currentComponentNodes.Add(startNode);

        while (q_bfs.Count > 0)
        {
            int u = q_bfs.Dequeue();

            foreach (int v in adj[u])
            {
                if (u < v) totalEdges++; 

                if (boja[v] == 0)
                {
                    boja[v] = 3 - boja[u]; 
                    q_bfs.Enqueue(v);
                    currentComponentNodes.Add(v);
                }
            }
        }
        
        foreach (int u in currentComponentNodes)
        {
             foreach (int v in adj[u])
             {
                 if (u < v)
                 {
                    if (boja[u] == boja[v])
                    {
                        if (boja[u] == 1)
                        {
                            neispunjeno1++;
                        }
                        else 
                        {
                            neispunjeno2++;
                        }
                    }
                 }
             }
        }

        long ispunjenopodela1 = totalEdges - (neispunjeno1 + neispunjeno2);
        long ispunjenopodela2 = totalEdges - ispunjenopodela1;
        
        componentNodes = currentComponentNodes;
        return (ispunjenopodela1, ispunjenopodela2);
    }
    public static void Main(string[] args)
    {
        var citac = Console.In;
        var pisac = Console.Out;
        string line1 = citac.ReadLine();
        if (string.IsNullOrEmpty(line1)) return;
        var parts = line1.Split(new[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
        if (parts.Length < 2) return;
        int N = int.Parse(parts[0]);
        int M = int.Parse(parts[1]);
        adj = new List<int>[N + 1];
        for (int i = 1; i <= N; i++)
        {
            adj[i] = new List<int>();
        }
        
        for (int i = 0; i < M; i++)
        {
            string line = citac.ReadLine();
            if (string.IsNullOrEmpty(line)) continue;
            var edgeParts = line.Split(new[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
            if (edgeParts.Length < 2) continue;
            int u = int.Parse(edgeParts[0]);
            int v = int.Parse(edgeParts[1]);
            adj[u].Add(v);
            adj[v].Add(u);
        }
        boja = new int[N + 1];
        List<Komponenta> komponente = new List<Komponenta>();
        for (int i = 1; i <= N; i++)
        {
            if (boja[i] == 0)
            {
                List<int> componentNodes;
                var (ispunjeno1, ispunjeno2) = BFS_Coloring(i, N, adj, out componentNodes);
                
                var novaKomponenta = new Komponenta
                {
                    Ispunjenost1 = ispunjeno1,
                    Ispunjenost2 = ispunjeno2
                };
                
                foreach(int node in componentNodes)
                {
                    if (boja[node] == 1) novaKomponenta.S1.Add(node);
                    else if (boja[node] == 2) novaKomponenta.S2.Add(node);
                    boja[node] = 3; 
                }

                komponente.Add(novaKomponenta);
            }
        }
        List<int> Tim1 = new List<int>();
        List<int> Tim2 = new List<int>();
        foreach (var komp in komponente)
        {
            if (komp.Ispunjenost1 >= komp.Ispunjenost2)
            {
                Tim1.AddRange(komp.S1);
                Tim2.AddRange(komp.S2);
            }
            else
            {
                Tim1.AddRange(komp.S2);
                Tim2.AddRange(komp.S1);
            }
        }
        Tim1.Sort();
        Tim2.Sort();
        pisac.WriteLine($"{Tim1.Count} {Tim2.Count}");
        pisac.WriteLine(string.Join(" ", Tim1));
        pisac.WriteLine(string.Join(" ", Tim2));
    }
}