from collections import deque
import sys

input = sys.stdin.read
data = input().split()

N = int(data[0])
M = int(data[1])
edges = []
index = 2
for i in range(M):
    a = int(data[index])
    b = int(data[index + 1])
    edges.append((a, b))
    index += 2

adj = [[] for _ in range(N + 1)]
for a, b in edges:
    adj[a].append(b)
    adj[b].append(a)

visited = [False] * (N + 1)
total_satisfied = 0
chosen_colorings = {}  # component_id -> color list

component_id = 0

def find_component(start):
    component = []
    queue = deque([start])
    visited[start] = True
    component.append(start)
    while queue:
        u = queue.popleft()
        for v in adj[u]:
            if not visited[v]:
                visited[v] = True
                component.append(v)
                queue.append(v)
    return component

def bfs_color(component, start, color_start):
    color = [-1] * (N + 1)
    queue = deque([start])
    color[start] = color_start
    while queue:
        u = queue.popleft()
        for v in adj[u]:
            if color[v] == -1:
                color[v] = 1 - color[u]
                queue.append(v)
            # No conflict check, just assign
    return color

for i in range(1, N + 1):
    if not visited[i]:
        component = find_component(i)
        
        # Try two colorings
        color1 = bfs_color(component, component[0], 0)
        color2 = bfs_color(component, component[0], 1)
        
        # Compute satisfied for color1
        satisfied1 = 0
        for u in component:
            for v in adj[u]:
                if color1[u] != color1[v]:
                    satisfied1 += 1
        satisfied1 //= 2
        
        # Compute satisfied for color2
        satisfied2 = 0
        for u in component:
            for v in adj[u]:
                if color2[u] != color2[v]:
                    satisfied2 += 1
        satisfied2 //= 2
        
        max_satisfied = max(satisfied1, satisfied2)
        total_satisfied += max_satisfied
        
        # Choose the coloring with max satisfied
        if satisfied1 >= satisfied2:
            chosen_colorings[component_id] = color1
        else:
            chosen_colorings[component_id] = color2
        
        component_id += 1

if total_satisfied >= M // 2:
    # Collect teams
    team0 = []
    team1 = []
    for cid in chosen_colorings:
        color = chosen_colorings[cid]
        for u in range(1, N + 1):
            if color[u] == 0:
                team0.append(u)
            elif color[u] == 1:
                team1.append(u)
    
    team0.sort()
    team1.sort()
    
    print(len(team0), len(team1))
    print(' '.join(map(str, team0)))
    print(' '.join(map(str, team1)))
else:
    print(-1)