using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        var line1 = Console.ReadLine().Split();
        int n = int.Parse(line1[0]);
        int m = int.Parse(line1[1]);

        var weights = Console.ReadLine()
            .Split(new[] { ' ' }, StringSplitOptions.RemoveEmptyEntries)
            .Select(long.Parse)
            .OrderBy(x => x)
            .ToArray();

        int k = m - (n - 1);

        if (k == 0)
        {
            Console.WriteLine(weights.Sum());
            return;
        }

        long bestMst = 0;

        long[] prefix = new long[m + 1];
        for (int i = 0; i < m; i++)
            prefix[i + 1] = prefix[i] + weights[i];

        bestMst = Math.Max(bestMst, prefix[n - 1]);

        if (n <= 15)
        {
            int[] indices = new int[n - 1];
            for (int i = 0; i < n - 1; i++)
                indices[i] = i;

            while (true)
            {
                long[] stab = new long[n - 1];
                HashSet<int> stabSet = new HashSet<int>(indices);
                for (int i = 0; i < n - 1; i++)
                    stab[i] = weights[indices[i]];

                List<long> vanst = new List<long>();
                for (int i = 0; i < m; i++)
                    if (!stabSet.Contains(i))
                        vanst.Add(weights[i]);

                Array.Sort(stab);
                Array.Reverse(stab);

                vanst.Sort();
                vanst.Reverse();

                bool feasible = true;
                for (int i = 0; i < k && i < n - 1 && feasible; i++)
                {
                    if (vanst[i] < stab[i])
                        feasible = false;
                }

                if (feasible)
                {
                    long sum = stab.Sum();
                    bestMst = Math.Max(bestMst, sum);
                }

                if (!NextCombination(indices, m))
                    break;
            }
        }
        else
        {
            bestMst = prefix[n - 1];
        }

        Console.WriteLine(bestMst);
    }

    static bool NextCombination(int[] indices, int n)
    {
        int k = indices.Length;
        int i = k - 1;
        while (i >= 0 && indices[i] == n - k + i)
            i--;
        if (i < 0)
            return false;
        indices[i]++;
        for (int j = i + 1; j < k; j++)
            indices[j] = indices[j - 1] + 1;
        return true;
    }
}