using System;
using System.Collections.Generic;

class Potera
{
    // Dinic's algorithm for Maximum Flow
    static int N; // number of nodes in flow network
    static List<int>[] adj; // adjacency list
    static int[] level, iter;
    static int[,] capacity;
    
    const int INF = int.MaxValue / 2;
    
    static void AddEdge(int from, int to, int cap)
    {
        adj[from].Add(to);
        adj[to].Add(from);
        capacity[from, to] += cap;
        // capacity[to, from] += 0; // reverse edge starts with 0
    }
    
    static bool BFS(int s, int t)
    {
        level = new int[N];
        for (int i = 0; i < N; i++) level[i] = -1;
        
        Queue<int> queue = new Queue<int>();
        level[s] = 0;
        queue.Enqueue(s);
        
        while (queue.Count > 0)
        {
            int v = queue.Dequeue();
            foreach (int to in adj[v])
            {
                if (capacity[v, to] > 0 && level[to] < 0)
                {
                    level[to] = level[v] + 1;
                    queue.Enqueue(to);
                }
            }
        }
        
        return level[t] >= 0;
    }
    
    static int DFS(int v, int t, int f)
    {
        if (v == t) return f;
        
        for (; iter[v] < adj[v].Count; iter[v]++)
        {
            int to = adj[v][iter[v]];
            if (capacity[v, to] > 0 && level[v] < level[to])
            {
                int d = DFS(to, t, Math.Min(f, capacity[v, to]));
                if (d > 0)
                {
                    capacity[v, to] -= d;
                    capacity[to, v] += d;
                    return d;
                }
            }
        }
        
        return 0;
    }
    
    static int MaxFlow(int s, int t)
    {
        int flow = 0;
        while (BFS(s, t))
        {
            iter = new int[N];
            int f;
            while ((f = DFS(s, t, INF)) > 0)
            {
                flow += f;
            }
        }
        return flow;
    }
    
    static void Solve()
    {
        string[] firstLine = Console.ReadLine().Split();
        int n = int.Parse(firstLine[0]);
        int m = int.Parse(firstLine[1]);
        
        int[] K = new int[n];
        string[] kLine = Console.ReadLine().Split();
        for (int i = 0; i < n; i++)
        {
            K[i] = int.Parse(kLine[i]);
        }
        
        // Read edges
        List<int[]> edges = new List<int[]>();
        for (int i = 0; i < m; i++)
        {
            string[] edgeLine = Console.ReadLine().Split();
            int a = int.Parse(edgeLine[0]);
            int b = int.Parse(edgeLine[1]);
            edges.Add(new int[] { a, b });
        }
        
        // Build flow network
        // Nodes: 0..n-1 are rooms, n is source (S), n+1 is sink (T)
        int source = n;
        int sink = n + 1;
        N = n + 2;
        
        adj = new List<int>[N];
        for (int i = 0; i < N; i++)
        {
            adj[i] = new List<int>();
        }
        capacity = new int[N, N];
        
        int sumPositive = 0;
        
        // Add edges from source and to sink based on K values
        for (int i = 0; i < n; i++)
        {
            if (K[i] > 0)
            {
                AddEdge(source, i, K[i]);
                sumPositive += K[i];
            }
            else if (K[i] < 0)
            {
                AddEdge(i, sink, -K[i]);
            }
        }
        
        // Add original graph edges with infinite capacity
        // Using a large enough value instead of true infinity
        int largeCapacity = 1000000;
        foreach (var edge in edges)
        {
            AddEdge(edge[0], edge[1], largeCapacity);
        }
        
        // Calculate max closure
        int minCut = MaxFlow(source, sink);
        int maxClosure = sumPositive - minCut;
        
        if (maxClosure > 0)
        {
            Console.WriteLine(maxClosure);
        }
        else
        {
            Console.WriteLine(-1);
        }
    }
    
    static void Main()
    {
        int T = int.Parse(Console.ReadLine());
        for (int t = 0; t < T; t++)
        {
            Solve();
        }
    }
}