#include <bits/stdc++.h>
using namespace std;

using ll = long long;

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;
    while(T--){
        int N, M;
        cin >> N >> M;

        vector<ll> K(N);
        for(int i = 0; i < N; i++) cin >> K[i];

        vector<vector<int>> g(N), gr(N);
        for(int i = 0; i < M; i++){
            int a, b;
            cin >> a >> b;
            g[a].push_back(b);
            gr[b].push_back(a);
        }

        vector<int> order;
        vector<char> vis(N, 0);

        function<void(int)> dfs1 = [&](int v){
            vis[v] = 1;
            for(int u : g[v])
                if(!vis[u]) dfs1(u);
            order.push_back(v);
        };

        for(int i = 0; i < N; i++)
            if(!vis[i]) dfs1(i);

        vector<int> comp(N, -1);
        int cid = 0;

        function<void(int)> dfs2 = [&](int v){
            comp[v] = cid;
            for(int u : gr[v])
                if(comp[u] == -1) dfs2(u);
        };

        for(int i = N - 1; i >= 0; i--){
            int v = order[i];
            if(comp[v] == -1){
                dfs2(v);
                cid++;
            }
        }

        vector<ll> sum(cid, 0);
        vector<int> out(cid, 0);

        for(int i = 0; i < N; i++)
            sum[comp[i]] += K[i];

        for(int v = 0; v < N; v++){
            for(int u : g[v]){
                if(comp[v] != comp[u])
                    out[comp[v]]++;
            }
        }

        ll ans = 0;
        for(int i = 0; i < cid; i++){
            if(out[i] == 0 && sum[i] > 0)
                ans += sum[i];
        }

        if(ans > 0) cout << ans << "\n";
        else cout << -1 << "\n";
    }

    return 0;
}