#include <bits/stdc++.h>
using namespace std;

const int MAXN = 505;

vector<int> adj[MAXN];
int N, M;
int K[MAXN];
bool visited[MAXN];
int disc[MAXN], low[MAXN], inStack[MAXN];
stack<int> st;
int timeDFS;
vector<vector<int>> SCCs;

void tarjanDFS(int u) {
    disc[u] = low[u] = ++timeDFS;
    st.push(u);
    inStack[u] = 1;

    for (int v : adj[u]) {
        if (!disc[v]) {
            tarjanDFS(v);
            low[u] = min(low[u], low[v]);
        } else if (inStack[v]) {
            low[u] = min(low[u], disc[v]);
        }
    }

    if (low[u] == disc[u]) {
        vector<int> scc;
        int v;
        do {
            v = st.top(); st.pop();
            inStack[v] = 0;
            scc.push_back(v);
        } while (v != u);
        SCCs.push_back(scc);
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;
    while (T--) {
        cin >> N >> M;
        for (int i = 0; i < N; i++) {
            cin >> K[i];
            adj[i].clear();
            disc[i] = low[i] = inStack[i] = 0;
        }
        SCCs.clear();
        timeDFS = 0;

        for (int i = 0; i < M; i++) {
            int a, b;
            cin >> a >> b;
            adj[a].push_back(b);
        }

        // Pronadji sve SCC
        for (int i = 0; i < N; i++) {
            if (!disc[i]) tarjanDFS(i);
        }

        // Pronadi SCC koji je "sink" (nema izlazne grane)
        int maxQuality = -1;
        for (auto &scc : SCCs) {
            int sum = 0;
            bool hasOutgoing = false;
            for (int u : scc) {
                sum += K[u];
                for (int v : adj[u]) {
                    if (find(scc.begin(), scc.end(), v) == scc.end()) {
                        hasOutgoing = true;
                        break;
                    }
                }
                if (hasOutgoing) break;
            }
            if (!hasOutgoing && sum > 0) {
                maxQuality = max(maxQuality, sum);
            }
        }

        cout << maxQuality << "\n";
    }

    return 0;
}