using System;
using System.Collections.Generic;

class Program
{
    static List<int>[] g;
    static int[] boja;
    static bool[] koristi;

    static void Main()
    {
        var prvi = Console.ReadLine().Split();
        int N = int.Parse(prvi[0]);
        int M = int.Parse(prvi[1]);

        g = new List<int>[N + 1];
        for (int i = 1; i <= N; i++)
            g[i] = new List<int>();

        var krajevi = new List<(int, int)>();

        for (int i = 0; i < M; i++)
        {
            var s = Console.ReadLine().Split();
            int a = int.Parse(s[0]);
            int b = int.Parse(s[1]);
            g[a].Add(b);
            g[b].Add(a);
            krajevi.Add((a, b));
        }

        boja = new int[N + 1];
        koristi = new bool[N + 1];
        for (int i = 1; i <= N; i++) boja[i] = -1;

        int[] konacnaboja = new int[N + 1];
        int zadovoljni = 0;

        for (int start = 1; start <= N; start++)
        {
            if (koristi[start]) continue;

            // BFS za komponentu
            Queue<int> q = new Queue<int>();
            List<int> comp = new List<int>();

            koristi[start] = true;
            boja[start] = 0;
            q.Enqueue(start);

            while (q.Count > 0)
            {
                int u = q.Dequeue();
                comp.Add(u);

                foreach (int v in g[u])
                {
                    if (!koristi[v])
                    {
                        koristi[v] = true;
                        boja[v] = boja[u] ^ 1;
                        q.Enqueue(v);
                    }
                }
            }

            int ok1 = 0, ok2 = 0;

            foreach (var e in krajevi)
            {
                int a = e.Item1, b = e.Item2;
                if (!comp.Contains(a) || !comp.Contains(b)) continue;

                if (boja[a] != boja[b]) ok1++;
                if ((boja[a] ^ 1) != (boja[b] ^ 1)) ok2++;
            }

            bool flip = ok2 > ok1;
            zadovoljni += Math.Max(ok1, ok2);

            foreach (int v in comp)
                konacnaboja[v] = flip ? boja[v] ^ 1 : boja[v];
        }

        if (zadovoljni < M / 2)
        {
            Console.WriteLine("-1");
            return;
        }

        List<int> t1 = new List<int>();
        List<int> t2 = new List<int>();

        for (int i = 1; i <= N; i++)
        {
            if (konacnaboja[i] == 0) t1.Add(i);
            else t2.Add(i);
        }

        Console.WriteLine(t1.Count + " " + t2.Count);
        Console.WriteLine(string.Join(" ", t1));
        Console.WriteLine(string.Join(" ", t2));
    }
}