#include <iostream>
#include <algorithm>
#include <vector>
#include <climits>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    int n, m;
    cin >> n >> m;

    vector<vector<int>> graf(n + 1);

    for (int i = 0; i < m; i++) {
        int a, b;
        cin >> a >> b;
        graf[a].push_back(b);
        graf[b].push_back(a);
    }

    vector<int> tim(n + 1, -1);

    for (int v = 1; v <= n; v++) {
        int t0 = 0, t1 = 0;
        for (int u : graf[v]) {
            if (tim[u] == 0) t0++;
            else if (tim[u] == 1) t1++;
        }
        tim[v] = (t0 > t1) ? 1 : 0;
    }

    vector<int> prvi, drugi;

    for (int v = 1; v <= n; v++) tim[v] ? prvi.push_back(v) : drugi.push_back(v);

    cout << prvi.size() << " " << drugi.size() << endl;
    for (int x : prvi) cout << x << " ";
    cout << endl;
    for (int x : drugi) cout << x << " ";
    cout << endl;

    return 0;
}