#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;
    while (T--) {
        int N, M;
        cin >> N >> M;
        vector<int> K(N);
        for (int i = 0; i < N; i++) cin >> K[i];

        vector<vector<int>> adj(N);
        vector<vector<int>> radj(N);
        for (int i = 0; i < M; i++) {
            int u, v;
            cin >> u >> v;
            adj[u].push_back(v);
            radj[v].push_back(u);
        }


        vector<bool> visited(N, false);
        vector<int> order;
        function<void(int)> dfs1 = [&](int u) {
            visited[u] = true;
            for (int v : adj[u])
                if (!visited[v]) dfs1(v);
            order.push_back(u);
        };
        for (int i = 0; i < N; i++)
            if (!visited[i]) dfs1(i);

        vector<int> comp(N, -1);
        function<void(int,int)> dfs2 = [&](int u,int c) {
            comp[u] = c;
            for (int v : radj[u])
                if (comp[v] == -1) dfs2(v,c);
        };

        int C = 0;
        for (int i = N-1; i >= 0; i--)
            if (comp[order[i]] == -1) dfs2(order[i],C++);

        vector<long long> sum(C,0);
        vector<int> outdeg(C,0);
        for (int i = 0; i < N; i++) sum[comp[i]] += K[i];

        for (int u = 0; u < N; u++)
            for (int v : adj[u])
                if (comp[u] != comp[v]) outdeg[comp[u]]++;

        long long ans = -1e18;
        for (int i = 0; i < C; i++)
            if (outdeg[i] == 0) ans = max(ans,sum[i]);

        cout << (ans > 0 ? ans : -1) << "\n";
    }
    return 0;
}