using System;
using System.Collections.Generic;

class HelloWorld
{
    static void Main()
    {
        string[] prva = Console.ReadLine().Split();
        int n = int.Parse(prva[0]);
        int m = int.Parse(prva[1]);

        List<int>[] graf = new List<int>[n + 1];
        for (int i = 1; i <= n; i++)
            graf[i] = new List<int>();

        int[] a = new int[m];
        int[] b = new int[m];

        for (int i = 0; i < m; i++)
        {
            string[] linija = Console.ReadLine().Split();
            a[i] = int.Parse(linija[0]);
            b[i] = int.Parse(linija[1]);
            graf[a[i]].Add(b[i]);
            graf[b[i]].Add(a[i]);
        }

        int[] boja = new int[n + 1];
        for (int i = 1; i <= n; i++)
            boja[i] = -1;

        bool[] koristi = new bool[n + 1];

        for (int start = 1; start <= n; start++)
        {
            if (boja[start] != -1) continue;

            Queue<int> red = new Queue<int>();
            List<int> komponenta = new List<int>();

            boja[start] = 0;
            red.Enqueue(start);
            komponenta.Add(start);

            while (red.Count > 0)
            {
                int u = red.Dequeue();
                foreach (int v in graf[u])
                {
                    if (boja[v] == -1)
                    {
                        boja[v] = 1 - boja[u];
                        red.Enqueue(v);
                        komponenta.Add(v);
                    }
                }
            }

            int zadovoljeno1 = 0;
            int zadovoljeno2 = 0;

            foreach (int u in komponenta)
            {
                foreach (int v in graf[u])
                {
                    if (u < v)
                    {
                        if (boja[u] != boja[v]) zadovoljeno1++;
                        else zadovoljeno2++;
                    }
                }
            }

            bool obrni = zadovoljeno2 > zadovoljeno1;

            foreach (int u in komponenta)
            {
                if (obrni)
                    koristi[u] = boja[u] == 1;
                else
                    koristi[u] = boja[u] == 0;
            }
        }

        List<int> tim1 = new List<int>();
        List<int> tim2 = new List<int>();

        for (int i = 1; i <= n; i++)
        {
            if (koristi[i]) tim1.Add(i);
            else tim2.Add(i);
        }

        Console.WriteLine(tim1.Count + " " + tim2.Count);

        foreach (int x in tim1)
            Console.Write(x + " ");
        Console.WriteLine();

        foreach (int x in tim2)
            Console.Write(x + " ");
        Console.WriteLine();
    }
}