#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);

    int n, m;
    cin >> n >> m;

    vector<vector<int>> adj(n + 1);
    for (int i = 0; i < m; i++) {
        int a, b;
        cin >> a >> b;
        adj[a].push_back(b);
        adj[b].push_back(a);
    }

    vector<int> team(n + 1, -1);

    for (int v = 1; v <= n; v++) {
        long long neighborsIn0 = 0, neighborsIn1 = 0;

        for (int u : adj[v]) {
            if (team[u] == -1) continue;
            if (team[u] == 0) neighborsIn0++;
            else neighborsIn1++;
        }

        team[v] = (neighborsIn1 >= neighborsIn0) ? 0 : 1;
    }

    long long cutEdges = 0;
    for (int v = 1; v <= n; v++) {
        for (int u : adj[v]) {
            if (u > v && team[u] != team[v]) cutEdges++;
        }
    }

    vector<int> groupA, groupB;
    groupA.reserve(n);
    groupB.reserve(n);

    for (int v = 1; v <= n; v++) {
        if (team[v] == 0) groupA.push_back(v);
        else groupB.push_back(v);
    }

    cout << groupA.size() << " " << groupB.size() << "\n";

    for (int i = 0; i < (int)groupA.size(); i++) {
        if (i) cout << ' ';
        cout << groupA[i];
    }
    cout << "\n";

    for (int i = 0; i < (int)groupB.size(); i++) {
        if (i) cout << ' ';
        cout << groupB[i];
    }
    cout << "\n";

    return 0;
}