import sys
from collections import deque

INF = 10**18

class Dinic:
    def __init__(self, n):
        self.n = n
        self.adj = [[] for _ in range(n)]

    def add_edge(self, u, v, c):
        self.adj[u].append([v, c, len(self.adj[v])])
        self.adj[v].append([u, 0, len(self.adj[u]) - 1])

    def maxflow(self, s, t):
        flow = 0
        while True:
            level = [-1] * self.n
            q = deque([s])
            level[s] = 0
            while q:
                v = q.popleft()
                for u, c, _ in self.adj[v]:
                    if c > 0 and level[u] < 0:
                        level[u] = level[v] + 1
                        q.append(u)
            if level[t] < 0:
                break

            it = [0] * self.n

            def dfs(v, f):
                if v == t:
                    return f
                for i in range(it[v], len(self.adj[v])):
                    it[v] = i
                    u, c, rev = self.adj[v][i]
                    if c > 0 and level[u] == level[v] + 1:
                        ret = dfs(u, min(f, c))
                        if ret:
                            self.adj[v][i][1] -= ret
                            self.adj[u][rev][1] += ret
                            return ret
                return 0

            while True:
                pushed = dfs(s, INF)
                if not pushed:
                    break
                flow += pushed
        return flow


def solve():
    input = sys.stdin.readline
    T = int(input())

    for _ in range(T):
        N, M = map(int, input().split())
        K = list(map(int, input().split()))