
<br>

Povjerenstvo za srednjoškolska natjecanja iz programiranja je prije skoro cijelog desetljeća konstatirala: *"Stari Babilonci koristili su jednu varijantu naprave Abak za komplicirane matematičke izračune..."*. Vi ste sada pronašli taj Abak (logično, pronašli ste ga na 3000 metara nadmorske visine u gnijezdu povjerenstva, gdje se čuvaju stara natjecanja).

<br>

Ono što je malo poznato, jeste da Abak nudi i zadaću. Kao nagradu za rješavanje zadaće, Abak će Vas vratiti u davnu 2016. godinu (što je jako dobro, jer znate rješenja svih zadaća s prošlih natjecanja).

<br>

Abak može za zadati prirodni broj izračunati umnožak (proizvod) njegovih znamenki (primjerice, za broj $123$, Abak bi vratio vrijednost $6=1\cdot 2\cdot 3$. Slično, za vrijednost $1024$, Abak bi vratio vrijednost $0=1\cdot 0\cdot 2\cdot 4$). Vaša zadaća je za zadati broj $n$ izračunati koliko različitih vrijednosti bi Abak vratio ako bi mu se unijeli brojevi  $1,2,\ldots,n$.

<br>

Kako biste bili sasvim sigurni u Vaše rješenje, morate odgovoriti na $T$ upita, gdje u svakome upitu dobijete broj $n$ i za svaki upit rješavate opisanu zadaću. Ako pogriješite, Abak Vas vraća u 2006. godinu umjesto 2016. godinu, a te zadaće već niste uvježbali...
 
<br>

## Opis ulaza

<br>

U prvoj liniji standardnog ulaza dan je prirodni broj $T$, broj upita.

<br>

U narednih $T$ linija standardnog ulaza, nalazi se po jedan prirodni broj - $n$. 

<br>

## Opis izlaza

<br>

Za svaki od $T$ upita treba ispisati jednu liniju standardnog izlaza koja sadrži jedan cijeli broj - broj različitih vrijednosti koje će Abak ispisati za unesene brojeve $1,2,\ldots,n$.

<br>

## Primjer 1

<br>

### Ulaz

<br>

```
3
1
10
13
```

<br>

### Izlaz

<br>

```
1
10
10
```

### Objašnjenje

<br>
 
   - U prvome upitu, Abaku dajemo samo broj $1$, njegov umnožak znamenki jednak je $1$ i to je jedina vrijednost koju će Abak vratiti. Ispis je onda $1$.
   - U drugome upitu, Abaku dajemo brojeve $1,2,3,4,5,6,7,8,9,10$ i umnožak znamenki ovih brojeva su redom $1,2,3,4,5,6,7,8,9,0$ - i tu imamo $10$ različitih vrijednosti, pa i ispisujemo $10$.
   - U trećemu upitu, Abaku dajemo brojeve $1,2,3,4,5,6,7,8,9,10,11,12,13$ i umnožak znamenki ovih brojeva su redom $1,2,3,4,5,6,7,8,9,0,1,2,3$ - i tu imamo ponovo $10$ različitih vrijednosti, pa i ispisujemo $10$. (Primijetimo da su posljednja tri vraćena broja duplikati, pa ispis nije $13$).

<br>

## Primjer 2

<br>

### Ulaz

<br>

```
1
111
```

<br>

### Izlaz

<br>

```
37
```

<br>

## Ograničenja


<br>


- $1 \leq T \leq 200.000$
- $1 \leq n \leq 10^{18}$ 


<br>

Test primjeri podijeljeni su u $8$ disjunktnih skupina:

   
   - U testovima vrijednim $5$ bodova: važi $n \leq 10$
   - U testovima vrijednim $5$ bodova: važi $n \leq 100$.
   - U testovima vrijednim $10$ bodova: važi $n \leq 10.000$.
   - U testovima vrijednim $10$ bodova: važi $n \leq 1.000.000$.
   - U testovima vrijednim $10$ bodova: važi $n \leq 10^9$.
   - U testovima vrijednimм $10$ bodova: važi $n \leq 10^{12}$.
   - U testovima vrijednim $10$ bodova: važi $T = 1$.
   - U testovima vrijednim $10$ bodova: važi $T \leq 1.000$.
   - U testovima vrijednim $30$ bodova: bez dodatnih ograničenja.

<br>
