#include <iostream>
#include <vector>

using namespace std;

struct Result {
    bool possible;
    int n;
    vector<vector<int>> matrix;
};

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int T;
    if (!(cin >> T)) return 0;

    vector<Result> results;

    for (int t = 0; t < T; t++) {
        int N, M;
        cin >> N >> M;

        Result res;
        res.n = N;

        if (N != M) {
            res.possible = false;
        } else {
            res.possible = true;
            res.matrix.assign(N, vector<int>(N, 0));

            for (int i = 0; i < N; i++) {
                for (int j = 0; j < N; j++) {
                    if (i == 0 || i == N - 1 || j == 0 || j == N - 1) {
                        res.matrix[i][j] = 1;
                    } else if (i == 2 && j == 2) { 
                        res.matrix[i][j] = 1;
                    }
                }
            }
        }
        results.push_back(res);
    }

    for (const auto& res : results) {
        if (!res.possible) {
            cout << -1 << "\n";
        } else {
            for (int i = 0; i < res.n; i++) {
                for (int j = 0; j < res.n; j++) {
                    cout << res.matrix[i][j] << (j == res.n - 1 ? "" : " ");
                }
                cout << "\n";
            }
        }
    }

    return 0;
}